<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../../../../gUtil/GestoreUpload.php";
    include "../../../../gUtil/ElaboratoreImmagini.php";
    include "../classi/ContenutiGirevoli.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $divGirevoli = new ContenutiGirevoli($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $divGirevoli = new ContenutiGirevoli($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    $impostazioni = recuperaImpostazioni($geecomDb);
    
    switch ($operazione) {
        case 'crea':
            $mostraTitoloComponente = (isset($_POST["mostraTitoloComponente"]) && $_POST["mostraTitoloComponente"]=="si") ? "si" : "no";
            $immaginiInBackground   = (isset($_POST["immaginiInBackground"]) && $_POST["immaginiInBackground"]=="si") ? "si" : "no";
            $divGirevoli->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $divGirevoli->setMostraTitoloComponente($mostraTitoloComponente);
            $divGirevoli->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $divGirevoli->setClasseElementi(filter_input(INPUT_POST,"classeElementi",FILTER_SANITIZE_STRING));
            $divGirevoli->setAspectRatioElementi(filter_input(INPUT_POST,"aspectRatioElementi",FILTER_SANITIZE_STRING));
            $divGirevoli->setImmaginiInBackground($immaginiInBackground);
            $divGirevoli->crea();
            header("Location: ../creaContenuti.php?id={$divGirevoli->getId()}&status=200");
            break;
        case 'modifica':
            $mostraTitoloComponente = (isset($_POST["mostraTitoloComponente"]) && $_POST["mostraTitoloComponente"]=="si") ? "si" : "no";
            $immaginiInBackground   = (isset($_POST["immaginiInBackground"]) && $_POST["immaginiInBackground"]=="si") ? "si" : "no";
            $divGirevoli->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $divGirevoli->setMostraTitoloComponente($mostraTitoloComponente);
            $divGirevoli->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $divGirevoli->setClasseElementi(filter_input(INPUT_POST,"classeElementi",FILTER_SANITIZE_STRING));
            $divGirevoli->setAspectRatioElementi(filter_input(INPUT_POST,"aspectRatioElementi",FILTER_SANITIZE_STRING));
            $divGirevoli->setImmaginiInBackground($immaginiInBackground);
            $divGirevoli->modifica();
            header("Location: ../creaContenuti.php?id={$divGirevoli->getId()}&status=250");
            break;
        case 'elimina':
            $divGirevoli->elimina();
            echo "ok";
            break;
        case 'duplica':
            $divGirevoli->caricaDatiDalDatabase();
            $idNuovaForm = $divGirevoli->duplica();
            header("Location: ../creaContenuti.php?id={$idNuovaForm}&status=260");
            break;
        case 'duplicaElemento':
            $idNuovoElemento = $divGirevoli->duplicaElemento(filter_input(INPUT_GET,"idElemento",FILTER_SANITIZE_NUMBER_INT));
            header("Location: ../creaElemento.php?id={$idNuovoElemento}&status=210");
            break;
        case 'creaElemento':
            $nome           = filter_input(INPUT_POST, "nome", FILTER_SANITIZE_ADD_SLASHES);
            $sfondoImmagine = filter_input(INPUT_POST, "sfondoImmagine",FILTER_SANITIZE_STRING);
            $sfondoDivTesto = filter_input(INPUT_POST, "sfondoTesto", FILTER_SANITIZE_STRING);
            
            $divGirevoli->creaElemento($nome,$sfondoImmagine,$sfondoDivTesto);
            echo "ok";
            break;
        case 'spostaElemento':
            $divGirevoli->spostaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST, "posizione",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'modificaElemento':
            $idElemento = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_STRING);
            $nome       = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
            $link       = filter_input(INPUT_POST,"link",FILTER_SANITIZE_STRING);
            $sfondoDivTesto         = filter_input(INPUT_POST,"sfondoDivTesto",FILTER_SANITIZE_STRING);
            $coloreTestoDivTesto    = filter_input(INPUT_POST,"coloreTestoDivTesto",FILTER_SANITIZE_STRING);
            $sfondoDivImmagine      = filter_input(INPUT_POST,"sfondoDivImmagine",FILTER_SANITIZE_STRING);
            $coloreTestoDivImmagine = filter_input(INPUT_POST,"coloreTestoDivImmagine",FILTER_SANITIZE_STRING);
            $testo                  = filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES);
            $classeELemento         = filter_input(INPUT_POST,"classeElemento",FILTER_SANITIZE_STRING);
            $etichetta              = filter_input(INPUT_POST,"etichetta",FILTER_SANITIZE_STRING);
            $divGirevoli->modificaElemento($idElemento,$nome, $link, $classeELemento, $sfondoDivTesto,$coloreTestoDivTesto,$sfondoDivImmagine,$coloreTestoDivImmagine,$testo,$etichetta);
            header("Location: ../creaElemento.php?id={$idElemento}&status=200");
            break;
        case 'stampaElementi':
            $divGirevoli->stampaElementi();
            break;
        case 'modificaImmagineElemento':
            $idElemento      = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../immagini/altro", 0);
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $divGirevoli->cambiaImmagineElemento($idElemento,$percorsoFoto);
            
            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                }
            }

            if($impostazioni["generaThumbnail"]=="si") {
                $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
            }
            
            echo "../../../$percorsoFoto";
            break;
        case 'eliminaImmagineElemento':
            $idElemento      = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $divGirevoli->cambiaImmagineElemento($idElemento,'');
            echo "ok";
            break;
        case 'modificaImmagineElementoConPercorso':
            $idElemento = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $percorso   = filter_input(INPUT_POST, "percorso",FILTER_SANITIZE_STRING);
            $divGirevoli->cambiaImmagineElemento($idElemento,$percorso);
            echo "ok";
            break;
        case 'eliminaElemento':
            $divGirevoli->eliminaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
    }
